#ifndef TT_TIMER_H /*********************************************************************************************/
#define TT_TIMER_H

/****************************************************************************************************************/

#include <sys/time.h>
#include <sys/cdefs.h>
__BEGIN_DECLS

/****************************************************************************************************************/

struct timerqueue;
struct timer;
typedef void timercallback_t(void *data);

/****************************************************************************************************************/

struct timerqueue *timerqueue_alloc(void);
void timerqueue_free(struct timerqueue *tq);
int timerqueue_checkpoint(struct timerqueue *tq);

/****************************************************************************************************************/
//
// Flags for timer_start()
//
#define TIMER_FREE_RUNNING	0		// Timer repeatedly triggers at given interval
#define TIMER_SINGLE_SHOT	1		// Trigger once, then stop

#define TIMER_REARM		2		// <ms> value is relative to time when last triggered

/****************************************************************************************************************/

struct timer *timer_alloc(struct timerqueue *tq, timercallback_t *callback, void *data);
void timer_free(struct timer *tmr);

void timer_start(struct timer *tmr, int ms, uint flags);
void timer_stop(struct timer *tmr);
int timer_timeout(struct timer *tmr);
int timer_remaining(struct timer *tmr, const struct timeval *tv);
int timer_is_active(struct timer *tmr);
const struct timeval *timer_expires(struct timer *tmr);

// Support freezing a timer in whatever state it is.
void timer_suspend(struct timer *tmr);
void timer_resume(struct timer *tmr);

/****************************************************************************************************************/
__END_DECLS
#endif
