#ifndef _TT_SLURP_H_
#define _TT_SLURP_H_

/****************************************************************************************************************/

#include <sys/types.h>
#include <sys/cdefs.h>

struct slurp {
  // Interface
  int fd;
  const void *data;
  size_t size;

  // Internal use
  void *data_mmap;
  void *data_malloc;
};

/****************************************************************************************************************/

__BEGIN_DECLS
void slurp_init(struct slurp *sl);
int slurp_open(struct slurp *sl, const char *filename);
void slurp_close(struct slurp *sl);
__END_DECLS

/****************************************************************************************************************/
#endif
