#ifndef _TEXT_BASE64_H_
#define _TEXT_BASE64_H_

#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WIN32
typedef int ssize_t;
typedef unsigned int size_t;
#endif

ssize_t libtext_base64_encode(const void *data, size_t len, char *buf, size_t bufsize, size_t width);
ssize_t libtext_base64_encode6(const void *data, size_t len, char *buf, size_t bufsize, size_t width, const char *linefeed);

ssize_t libtext_base64_decode(const char *data, size_t len, void *buf, size_t bufsize);

#ifdef __cplusplus
}
#endif

#endif
