#ifndef VK_PROTO_H
#define VK_PROTO_H

#include <stdarg.h>

/****************************************************************************************************************/
//
// Calls from upper layer to VK protocol driver
//

// Initialize data structure
void vk_proto_init(struct vk_driver *vkp);

// Start/Stop driver
void vk_proto_start(struct vk_driver *vkp);
void vk_proto_stop(struct vk_driver *vkp);

// Send command
//
// Timeout COMMAND -> <DLE> <ACK> is fixed to 5.02s as specified by Leadus.
// Timeout <DLE> <ENQ> -> RESPONSE is specified in <timeout> parameter (ms).
//
// On success, 0 is returned and command executes asynchronously.
// After completion or failure, the callback is called.
//
// On failure, an error code is returned (see below).
//
// If <timeout> is zero, uses the default timeout as recommended by Leadus.
//
// If <len> is zero, the code throws a strlen() at <cmd> first to determine it's length.
//
int vk_proto_send_command(struct vk_driver *vkp, const void *cmd, unsigned int len, unsigned int timeout);

// Abort current command.
// If a command is pending, int will be aborted immediately.
// commandComplete() will NOT be called anymore.
void vk_proto_abort_command(struct vk_driver *vkp);

// Abort current command.
// If a command is pending, int will be aborted immediately.
// vk_proto_command_complete() will NOT be called anymore.
void vk_proto_abort_command(struct vk_driver *vkp);

/****************************************************************************************************************/
/****************************************************************************************************************/
//
// Calls from system layer to VK protocol driver
//

// Call if retry timer has expired
void vk_proto_trigger_retry(struct vk_driver *vkp);

// Call if poll timer has expired
void vk_proto_trigger_poll(struct vk_driver *vkp);

// Call if data has been received
void vk_proto_read(struct vk_driver *vkp, const void *data, int len);

/****************************************************************************************************************/
/****************************************************************************************************************/

// Error codes

#define VK_BUSY			0x525000	// State machine is busy
#define VK_DTR_TIMEOUT		0x525001	// Reader not ready
#define VK_OVERFLOW		0x525003	// Transmit buffer overflow
#define VK_TIMEOUT		0x525004	// Protocol timed out
#define VK_SHORT_RESPONSE	0x525005	// Received response is too short
#define VK_INVALID_RESPONSE	0x525006	// Received response is invalid (sanity check failed)
#define VK_INVALID_COMMAND	0x525007	// Invalid command passed for transmission
#define VK_BUG			0x5250FF	// Umh...

/****************************************************************************************************************/
/****************************************************************************************************************/

#endif
