#ifndef KEYEVENT_H /****************************************************************************** -*- c++ -*- **/
#define KEYEVENT_H

/****************************************************************************************************************/

#include "events.h"

/****************************************************************************************************************/

class KeyEvent : public Event {
public:
  enum Key {
    keyNone      = 0,

    keyPad0      = 0x0130,
    keyPad1      = 0x0131,
    keyPad2      = 0x0132,
    keyPad3      = 0x0133,
    keyPad4      = 0x0134,
    keyPad5      = 0x0135,
    keyPad6      = 0x0136,
    keyPad7      = 0x0137,
    keyPad8      = 0x0138,
    keyPad9      = 0x0139,

    keyLeft      = 0x0141,
    keyRight     = 0x0142,
    keyEnter     = 0x0143,
    keyDown      = 0x0144,
    keyUp        = 0x0145,
    keyEscape    = 0x0146,

    keyDelete    = 0x0147,
    keyBackspace = 0x0148,
    keyTab       = 0x0149,
  };

public:
  KeyEvent(Key k) : Event(EVENT_KEY), m_key(k) { }

  void setCode(Key k) { m_key = k; }
  Key code(void) const { return m_key; }

  int key(void) const;

private:
  Key m_key;
};

/****************************************************************************************************************/

#endif
