#ifndef ARGV_H /********************************************************************************** -*- c++ -*- **/
#define ARGV_H

/****************************************************************************************************************/

class Argv {
public:
  Argv(unsigned int max_argc = 63);
  Argv(const char *line, unsigned int max_argc = 63);
  ~Argv();

public:
  void clear(void);
  char **split(const char *line);

  char *argv(unsigned int idx) const;
  char **argv(void) const { return m_argv; }
  int argc(void) const    { return m_argc; }

  bool append(const char *txt)  { return insert(m_argc, txt); }
  bool prepend(const char *txt) { return insert(0, txt);      }
  bool insert(unsigned int idx, const char *txt);
  bool remove(unsigned int idx);
  char *take(unsigned int idx);

  bool replace(unsigned int idx, const char *txt);
  int find(const char *txt);

  const char *concat(void) const;

  void dump(void) const;

private:
  void clrLine(void);
  bool ensureArgv(void);

private:
  char **m_argv;
  int m_argc;
  int m_max_argc;
  char *m_line;
};


/****************************************************************************************************************/

#endif

