#ifndef _CORE_TYPES_H_
#define _CORE_TYPES_H_

/****************************************************************************************************************/

typedef signed   long long  int64;
typedef unsigned long long uint64;

typedef int       	    int32;
typedef unsigned int       uint32;

typedef signed   short      int16;
typedef unsigned short     uint16;

typedef signed   char        int8;
typedef unsigned char       uint8;

typedef unsigned int         uint;

/****************************************************************************************************************/

typedef	int8   int8_t;
typedef	uint8  u_int8_t;
typedef	uint8  uint8_t;

typedef	int16  int16_t;
typedef	uint16 u_int16_t;
typedef	uint16 uint16_t;

typedef	int32  int32_t;
typedef	uint32 u_int32_t;
typedef	uint32 uint32_t;

typedef	int64  int64_t;
typedef	uint64 u_int64_t;
typedef	uint64 uint64_t;

/****************************************************************************************************************/
//
// This will make the OpenBSD derived sources happy
//

/* 7.18.1.1 Exact-width integer types (also in sys/types.h) */
typedef	int8   __int8_t;
typedef	uint8  __uint8_t;
typedef	int16  __int16_t;
typedef	uint16 __uint16_t;
typedef	int32  __int32_t;
typedef	uint32 __uint32_t;
typedef	int64  __int64_t;
typedef	uint64 __uint64_t;

/* 7.18.1.2 Minimum-width integer types */
typedef	int8   __int_least8_t;
typedef	uint8  __uint_least8_t;
typedef	int16  __int_least16_t;
typedef	uint16 __uint_least16_t;
typedef	int32  __int_least32_t;
typedef	uint32 __uint_least32_t;
typedef	int64  __int_least64_t;
typedef	uint64 __uint_least64_t;

/* 7.18.1.3 Fastest minimum-width integer types */
typedef	int8   __int_fast8_t;
typedef	uint8  __uint_fast8_t;
typedef	int16  __int_fast16_t;
typedef	uint16 __uint_fast16_t;
typedef	int32  __int_fast32_t;
typedef	uint32 __uint_fast32_t;
typedef	int64  __int_fast64_t;
typedef	uint64 __uint_fast64_t;

/* 7.18.1.4 Integer types capable of holding object pointers */
typedef	int32 __intptr_t;
typedef	uint32 __uintptr_t;

/* 7.18.1.5 Greatest-width integer types */
typedef	int64  __intmax_t;
typedef	uint64 __uintmax_t;

/* Wide characters */
#ifndef __cplusplus
typedef	int __wchar_t; // Phew...
#endif
typedef int __wint_t;
typedef int __rune_t;
typedef void *__wctrans_t;
typedef void *__wctype_t;

/* mbstate_t is an opaque object to keep conversion state, during multibyte
 * stream conversions. The content must not be referenced by user programs. */
typedef union {
  char __mbstate8[128];
  __int64_t __mbstateL;                   /* for alignment */
} __mbstate_t;

/* OpenBSD code needs this, too */
typedef __builtin_va_list __va_list;

typedef	__int64_t	quad_t;
typedef	__uint64_t	u_quad_t;
typedef	quad_t *	qaddr_t;

/****************************************************************************************************************/

typedef uint32 dev_t;
typedef uint32 ino_t;
typedef uint32 mode_t;
typedef uint32 nlink_t;
typedef  int   uid_t;
typedef  int   gid_t;
typedef uint32 blksize_t;
typedef uint64 blkcnt_t;
typedef  int64 time_t;
typedef  int32 suseconds_t;
typedef uint32 useconds_t;
typedef  int   pid_t;
typedef uint32 sigset_t;
typedef uint32 fsid_t;
typedef void  *caddr_t;
typedef  int   clockid_t;
typedef uint32 clock_t;
typedef  int   sig_atomic_t;
typedef long int __ptrdiff_t;

/****************************************************************************************************************/
/* Same types as used by gcc's stddef.h */

#undef __size_t // Unh?
typedef long unsigned int __size_t;
typedef long __ssize_t;

typedef long long unsigned int __size64_t;
typedef long long int __ssize64_t;

typedef uint32 __off_t;
typedef uint64 __off64_t;

/****************************************************************************************************************/

#ifdef __BSD_VISIBLE
/* Major, minor numbers, dev_t's. */
#define makedev(maj, min) (((maj)<<16) | (min))
#define major(dev) ((dev)>>16)
#define minor(dev) ((dev)&0xFFFF)
#endif

/****************************************************************************************************************/

#ifndef	_SIZE_T_DEFINED_
#define	_SIZE_T_DEFINED_
#define	_SIZE_T
typedef	__size_t	size_t;
#endif

#ifndef	_SSIZE_T_DEFINED_
#define	_SSIZE_T_DEFINED_
#define	_SSIZE_T
typedef	__ssize_t	ssize_t;
#endif

#ifndef	_SIZE64_T_DEFINED_
#define	_SIZE64_T_DEFINED_
#define	_SIZE64_T
typedef	__size64_t	size64_t;
#endif

#ifndef	_SSIZE64_T_DEFINED_
#define	_SSIZE64_T_DEFINED_
#define	_SSIZE64_T
typedef	__ssize64_t	ssize64_t;
#endif

#ifndef	_OFF_T_DEFINED_
#define	_OFF_T_DEFINED_
#define	_OFF_T
typedef	__off_t	off_t;
#endif

#ifndef	_OFF64_T_DEFINED_
#define	_OFF64_T_DEFINED_
#define	_OFF64_T
typedef	__off64_t off64_t;
#endif

#ifndef	_MBSTATE_T_DEFINED_
#define	_MBSTATE_T_DEFINED_
#define	_MBSTATE_T
typedef	__mbstate_t	mbstate_t;
#endif

#ifndef	_WINT_T_DEFINED_
#define	_WINT_T_DEFINED_
#define	_WINT_T
typedef	__wint_t	wint_t;
#endif

#ifndef	_PTRDIFF_T_DEFINED_
#ifndef _PTRDIFF_T
#define	_PTRDIFF_T_DEFINED_
#define _PTRDIFF_T
typedef	__ptrdiff_t	ptrdiff_t;
#endif
#endif

/****************************************************************************************************************/
#endif
