#ifndef _CORE_SYSCALL_SOCKET_H_ /********************************************************************************/
#define _CORE_SYSCALL_SOCKET_H_

/****************************************************************************************************************/

#include <core/syscall.h>
_syscall3(int, socket, int, domain, int, type, int, protocol);
_syscall3(int, bind, int, s, const struct sockaddr *, my_addr, socklen_t, addrlen);
_syscall2(int, listen, int, s, int, backlog);
_syscall3(int, accept, int, s, const struct sockaddr *,addr, socklen_t *,addrlen);
_syscall3(int, connect, int, s, const struct sockaddr *,serv_addr, socklen_t, addrlen);
_syscall2(int, shutdown, int, s, int, how);
_syscall5(int, getsockopt, int, s, int, level, int, optname, void *, optval, socklen_t *, optlen);
_syscall5(int, setsockopt, int, s, int, level, int, optname, const void *, optval, socklen_t, optlen);

_syscall4(ssize_t, send, int, s, const void *, buf, size_t, len, int, flags);

_syscall6(ssize_t, sendto, int, s, const void *, buf, size_t, len, int, flags,
	  const struct sockaddr *, to, socklen_t, tolen);

_syscall4(ssize_t, recv, int, s, void *, buf, size_t, len, int, flags);

_syscall6(ssize_t, recvfrom, int, s, void *, buf, size_t, len, int, flags,
	  struct sockaddr *, from, socklen_t *, fromlen);

/****************************************************************************************************************/
#endif
