#ifndef _CORE_SOCKBITS_H_ /**** USED BY LUA *********************************************************************/
#define _CORE_SOCKBITS_H_

/****************************************************************************************************************/

#define SHUT_RD		0	/* No more receptions.			*/
#define SHUT_WR		1	/* No more transmissions.		*/
#define SHUT_RDWR	2	/* No more receptions or transmissions.	*/

/****************************************************************************************************************/

#define SOCK_STREAM	1	/* Sequenced, reliable, connection-based byte streams.				*/
#define SOCK_DGRAM	2	/* Connectionless, unreliable datagrams of fixed maximum length.		*/
#define SOCK_RAW	3	/* Raw protocol interface.							*/
#define SOCK_RDM	4	/* Reliably-delivered messages.							*/
#define SOCK_SEQPACKET	5	/* Sequenced, reliable, connection-based, datagrams of fixed maximum length.	*/

/****************************************************************************************************************/

#define PF_LOCAL	1	/* Local to host (pipes and file-domain).					*/
#define PF_UNIX		PF_LOCAL
#define PF_INET		2	/* IP protocol family.								*/

/****************************************************************************************************************/

#define AF_UNSPEC	0
#define AF_LOCAL	PF_LOCAL
#define AF_UNIX		AF_LOCAL
#define AF_INET		PF_INET

/****************************************************************************************************************/

#define SOL_SOCKET	0xFFFF
#define SOL_RAW		255

#define SOL_IP		0
#define SOL_ICMP	1
#define SOL_TCP		6
#define SOL_UDP		17
#define SOL_CORE4	196

/****************************************************************************************************************/

#define SO_DEBUG	1
#define SO_REUSEADDR	2
#define SO_TYPE         3
#define SO_ERROR        4
#define SO_DONTROUTE	5
#define SO_BROADCAST	6
#define SO_SNDBUF	7
#define SO_RCVBUF	8
#define SO_KEEPALIVE	9
#define SO_OOBINLINE	10
#define SO_NO_CHECK	11
#define SO_PRIORITY	12
#define SO_LINGER	13
#define SO_BSDCOMPAT	14
#define SO_REUSEPORT	15
#define SO_PASSCRED	16
#define SO_PEERCRED	17
#define SO_RCVLOWAT	18
#define SO_SNDLOWAT	19
#define SO_RCVTIMEO	20
#define SO_SNDTIMEO	21

#define SO_TRACE	255

/* Temporary kludge (TM) */
#define SO_ROUTER	256
#define SO_SYSLOG	257

/****************************************************************************************************************/

#define SOCK_TRACE_NONE		0
#define SOCK_TRACE_MIN		1
#define SOCK_TRACE_NORMAL	2
#define SOCK_TRACE_DETAIL	3

/****************************************************************************************************************/

#define TCP_NODELAY		1

/****************************************************************************************************************/
#endif
