#ifndef _CORE4_BARCODE_H_ /**************************************************************************************/
#define _CORE4_BARCODE_H_

/****************************************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

//
// Calculates the pattern of the barcode by generating a string of ASCII numbers into buf.
// The first digit describes the width of a black bar, the second describes a white bar, etc...
//
// When called with buf=NULL, returns the minimum buffer size needed to generate this barcode.
//
// When buf is non-NULL, barcode is stored into the buffer and the total width of the barcode
// (the sum of all digits generated) is returned.
//
// Any checksums are generated automatically.
//

//
// Code 2/5
// This barcode only does digits.
//
unsigned int code25m_generate(const char *text, char *buf, unsigned int bufsize);

//
// Code 2/5 interleaved
// This barcode only does digits.
//
// Note that this barcode needs an even number of digits to work. Since a check digit is automatically
// added, you must pass an odd number of digits to this function.
//
unsigned int code25i_generate(const char *text, char *buf, unsigned int bufsize);

//
// EAN8 or EAN13
// This barcode only does digits.
//
// As the check digit is automatically added, pass 7 digits to generate an EAN8 and pass
// 12 digits to generate an EAN13.
//
unsigned int codeean_generate(const char *text, char *buf, unsigned int bufsize);

//
// Code 93
// This barcode does digits, upper case letters and a few extra characters.
//
unsigned int code93_generate(const char *text, char *buf, unsigned int bufsize);

//
// Code 128
// Does most of ASCII.
//
unsigned int code128_generate(const char *text, char *buf, unsigned int bufsize);

#ifdef __cplusplus
}
#endif

/****************************************************************************************************************/
#endif

