#ifndef _TT_CORDIC32_H_
#define _TT_CORDIC32_H_

#include <sys/types.h>

#define CORDIC32_HALF_PI	0x6487ED51
#define CORDIC32_PI		0xC90FDAA2LL
#define CORDIC32_2PI		0x1921FB544LL
#define CORDIC32_MUL		1073741824

struct cordic32 {
  int sine;
  int cosine;
  int tangens;
};

void cordic32(int theta, struct cordic32 *cordic);

int cordic32_sin(int theta);
int cordic32_cos(int theta);
int cordic32_tan(int theta);

#endif
