#ifndef _UNICODE_UTF8_H_
#define _UNICODE_UTF8_H_

#include <stdlib.h> /* WIN32: size_t */
#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************************************************/
//
// Supports UTF8 codes for value range 0x000000 .. 0x1FFFFF only.
// Higher values are of academical interest, only.
//
/****************************************************************************************************************/
//
// Decodes UTF8 code sequences
//
// Initialize state to zero before beginning, then feed each byte through the decoder.
//
// Return values:
//
//	<0	- Need more data to decode multibyte sequence
//	>=0	- Unicode codepoint of the next character
//
// Invalid byte sequences are reported as unicode replacement character 0xFFFD
//
int utf8_decode(unsigned int ch, unsigned int *state);

// Same as above, but expects the bytes to come up in reverse order.
int utf8_decode_reverse(unsigned int ch, unsigned int *state);

/****************************************************************************************************************/
//
// Encodes UTF8 code sequences
//
// Take given unicode character <ch> and convert it into a multibyte UTF8 sequence.
//
// Buffer must be able to hold five bytes.
//
// Returns number of bytes generated.
// The buffer will contain a trailing zero, which is not included in this value.
//
unsigned int utf8_encode(char *buf, unsigned int ch);

/****************************************************************************************************************/
//
// Counts number of characters in an utf8 encoded string.
//
// <byte_count> is the number of bytes in the string.
// Does NOT stop at a 0 byte.
//
size_t utf8nlen(const char *str, size_t byte_count);

/****************************************************************************************************************/
//
// Counts number of characters in an utf8 encoded string.
// Stops at a 0 byte.
//
size_t utf8len(const char *str);

/****************************************************************************************************************/

#ifdef __cplusplus
}
#endif

#endif
