#ifndef _SYS_CDEFS_H_
#define _SYS_CDEFS_H_

/********************************************************************************************************/

#include <core/cdefs.h>

#if defined(__cplusplus)
#define __BEGIN_DECLS   extern "C" {
#define __END_DECLS     }
#else
#define __BEGIN_DECLS
#define __END_DECLS
#endif

/********************************************************************************************************/

#define __CONCAT(x,y)   x ## y
#define __STRING(x)     #x
#define __dead __attribute__((__noreturn__))

/********************************************************************************************************/

#define __weak_alias(alias,sym)                                 \
        __asm__(".weak " __STRING(alias) " ; " __STRING(alias)  \
            " = " __STRING(sym))

#define __warn_references(sym,msg)                              \
        __asm__(".section .gnu.warning." __STRING(sym)          \
            " ; .ascii \"" msg "\" ; .text")

/********************************************************************************************************/
#endif
