#ifndef XK_ENUM_H
#define XK_ENUM_H

/****************************************************************************************************************/
//
// Selected reader protocol group
//
enum xk_protocol_type {
  xkpLeadus,
  xkpSankyo,
  xkpHoptSchuler,
};

/****************************************************************************************************************/
//
// Type of detected reader
//
enum xk_reader_type {
  xkrV4KF,
  xkrV2BF,
  xkrV2XF,
  xkrSankyo,
  xkrHS,
};

/****************************************************************************************************************/
//
// Card types -- also defined in lua/v4kf.lh
//
enum xk_chip_type {
  xkcNone		=	0,	// Chip type not known
  xkcMemory		=	1,	// Unknown memory chip with ATR
  xkcMemorySLE4442	=	2,	// Infineon SLE4442
  xkcMemorySLE4432	=	3,	// Infineon SLE4432
  xkcMemorySLE4428	=	4,	// Infineon SLE4428
  xkcMemorySLE4418	=	5,	// Infineon SLE4418
  xkcMemoryI2C11	=	6,	// I²C cards with 11bit addressing
  xkcMemoryI2C16	=	7,	// I²C cards with 16bit addressing
  xkcSmartcard		=	255,	// Smartcard protocols
};

#ifdef XK_CONFIG_TINYBUF
#define XK_CHIP_BUFSIZE 258	// 256 bytes max APDU size + 2 bytes status
#else
#define XK_CHIP_BUFSIZE 4096
#endif

/****************************************************************************************************************/
//
// State of reader
//
enum xk_state {
  xkReset,
  xkInitializing,
  xkClosed,
  xkAccepting,
  xkInserted,
  xkLocked,
  xkEjecting,
  xkProcessing,
  xkCapturing,
  xkError,
};

/****************************************************************************************************************/
//
// Sensors
//
enum xk_sensor {
  xksS0     = 0, // SW1/PD1	Card Width Sensor or card detect sensor
  xksS1     = 1, // PD2		Card detect sensor
  xksS2     = 2, // PD3		Card detect sensor
  xksS3     = 3, // PD4		Card detect sensor
  xksS4     = 4, // --
  xksWID    = 5, // SW1/PD1	Card Width Sensor or card detect sensor
  xksSHD    = 6, // --		
  xksSHE    = 7, // PI1		Shutter open/close
  xksICA    = 8, // PI2		IC activated
  xksCHE    = 9, // Virtual
  xksTamper = 10,// --
  xksMotor0 = 11,// --
  xksMotor1 = 12,// --
  xksCAP    = 13,// CAP		Capture sensor
};

/****************************************************************************************************************/
//
// Flags for insert command
//
enum xk_insert_flags {
  xkiAutolock          = 1, // Automatically press chip contact
  xkiCheckForMagstripe = 2, // Only accept cards with magstripe
  xkiWiggle            = 4, // Wiggle card around while pulling it in to thwart xkimming
};

/****************************************************************************************************************/
//
// Flags for smartcard chip enable command
//
enum xk_chip_flags {
  xkcAll = 1,
  xkcEfid = 2,
  xkcTrack2Equivalent = 4,
  xkcATR = 8,
  xkcPan = 16,
  xkcName = 32,
  xkcCountryCode = 64,
};

/****************************************************************************************************************/
//
// Error codes
//
#define XK_BUSY			0x525000	// State machine is busy
#define XK_DTR_TIMEOUT		0x525001	// Reader not ready
#define XK_OVERFLOW		0x525003	// Transmit buffer overflow
#define XK_TIMEOUT		0x525004	// Protocol timed out
#define XK_SHORT_RESPONSE	0x525005	// Received response is too short
#define XK_INVALID_RESPONSE	0x525006	// Received response is invalid (sanity check failed)
#define XK_INVALID_COMMAND	0x525007	// Invalid command passed for transmission
#define XK_UNSUPPORTED		0x525008	// Received something from reader that is not supported by driver
#define XK_BUG			0x5250FF	// Umh...

#define XK_RDR_OFFLINE		0x525301	// Reader is offline
#define XK_RDR_INVALID_SEQ	0x525302	// Invalid command sequence requested
#define XK_RDR_INVALID_VERSION	0x525303	// Version probing failed
#define XK_RDR_INVALID_PARAMETER 0x525304	// Invalid parameter passed
#define XK_RDR_NO_CARD		0x525305	// No card in reader
#define XK_RDR_BUSY		0x525306	// Sequence queue full
#define XK_RDR_TYPE_UNKNOWN	0x525307	// Cannot detect type of reader

#define XK_RDR_STATE_BUG	0x5253FF	// Bug in state machine

#define SK_RDR_ERROR		0x535B00	// Lower 8 bits indicate error code from reader
#define VK_RDR_ERROR		0x565B00	// Lower 8 bits indicate error code from reader
#define HS_RDR_ERROR            0x595B00        // Lower 8 bits indicate error code from reader

#define XK_OS_ERROR             0x5D0000        // Lower 16 bits indicate system error code

#define CHIP_ENABLE_FAILED	0x434800	// Chip activation failed
#define CHIP_READ_FAILED	0x434801	// Chip read command
#define CHIP_WRITE_FAILED	0x434802	// Chip write command
#define CHIP_BUFFER_OVERFLOW	0x434803	// Provided buffer was too small
#define CHIP_PIN_NOT_SUPPORTED	0x434804	// Chip does not support pin authentication
#define CHIP_ACCESS_FAILED	0x434805	// Chip access failed

/****************************************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

const char *xk_state_name(enum xk_state st);
const char *xk_strerror(int error_code);

#ifdef __cplusplus
}
#endif

/****************************************************************************************************************/

#endif
