#ifndef EVENTS_H /******************************************************************************** -*- c++ -*- **/
#define EVENTS_H

#include <sys/types.h>

/****************************************************************************************************************/

#define EVENT_NOP	0	/* Unused event code					*/
#define EVENT_CHILD	1	/* A child process has terminated			*/
#define EVENT_KEY	2	/* Keyboard event					*/
#define EVENT_TOUCH	3	/* Touch screen event					*/
#define EVENT_RAW_TOUCH	4	/* Raw touch screen event				*/
#define EVENT_TEXT	5	/* Generic text event					*/

#define EVENT_USER	0x10000	/* User defined events start here			*/

/****************************************************************************************************************/

class Event {
public:
  Event(int init_type, bool init_accept = false);

  void accept(void) { m_accepted = true; }
  void ignore(void) { m_accepted = false; }

  int type(void) const { return m_type; }

  bool accepted(void) const { return m_accepted; }
  bool ignored(void) const { return !m_accepted; }

private:
  int m_type;
  bool m_accepted;
};

/****************************************************************************************************************/

class ChildEvent : public Event {
public:
  ChildEvent(int init_pid, int init_result);

  int pid(void) const    { return m_pid;    }
  int result(void) const { return m_result; }

private:
  int m_pid;
  int m_result;
};

/****************************************************************************************************************/

class TextEvent : public Event {
public:
  TextEvent(const char *txt, size_t len);

  const char *text(void)  { return m_text; }
  const char length(void) { return m_len;  }

private:
  const char *m_text;
  size_t m_len;
};

/****************************************************************************************************************/
#endif
