#ifndef _CORE_TOUCHBITS_H_
#define _CORE_TOUCHBITS_H_

#include <core/types.h>

/****************************************************************************************************************/

/* IOCTLS */
#define TOUCH_PROBE		   0x7450	// Only successful if touch screen exists
#define TOUCH_SETCALIB		   0x7453	// Saves calibration to permanent storage
#define TOUCH_GETCALIB		   0x7447	// Fills a passed "struct touch_calibration"
#define TOUCH_GETDEFAULTCALIB	   0x7444	// Fills a passed "struct touch_calibration" with defaults

/* CALIBRATION FLAGS */
#define TOUCHCAL_SWAPPED		1	// X/Y wiring is swapped
#define TOUCHCAL_XMIRROR		2	// X signal is mirrored
#define TOUCHCAL_YMIRROR		4	// Y signal is mirrored
#define TOUCHCAL_HARDWARE_AVERAGING	8	// Hardware provides for averaging control
#define TOUCHCAL_FILTERED		16	// Controller does all the filtering
#define TOUCHCAL_DRIFT_FREE		32	// Once calibrated it will never drift.
#define TOUCHCAL_AUTOMATIC		64	// Can automatically calibrate.
#define TOUCHCAL_CALIBRATED		128	// Reports already calibrated pixel-correct values
#define TOUCHCAL_NO_PRESSURE		256	// Does NOT support pressure values
#define TOUCHCAL_MULTITOUCH		512	// Can report multiple fingers

// These flags are read-only
#define TOUCHCAL_CONSTANT_FLAGS \
            (TOUCHCAL_HARDWARE_AVERAGING | TOUCHCAL_FILTERED | TOUCHCAL_DRIFT_FREE | \
             TOUCHCAL_AUTOMATIC | TOUCHCAL_CALIBRATED | TOUCHCAL_NO_PRESSURE | \
             TOUCHCAL_MULTITOUCH)

/****************************************************************************************************************/
#endif
