#ifndef _CORE_CANBITS_H_ /**** USED BY LUA **********************************************************************/
#define _CORE_CANBITS_H_

/****************************************************************************************************************/
//
// CAN IOCTLs
//

#define CAN_RESET		0x4300	// Reset controller chip

#define CAN_SET_MASK		0x4301	// Set filter mask
#define CAN_GET_MASK		0x4302	// Read filter mask

#define CAN_SET_SPEED		0x4303	// Set bus speed (Set to 0 to disable)
#define CAN_GET_SPEED		0x4304	// Read bus speed

#define CAN_FLUSH		0x4305	// Discard Tx queue

#define CAN_REQUEST_STATE	0x4307	// Ask for update on bus state

#define CAN_TRACE		0x43FE	// Set tracing (DEBUG)
#define CAN_WORK		0x43FF	// Trigger work loop (DEBUG)

/****************************************************************************************************************/
//
// CAN PACKET STRUCTURE
//
//           3       2       1       0
//       +-------+-------+-------+-------+
//     0 +          IDENTIFIER           +
//       +-------+-------+-------+-------+
//     4 +  LEN  |  BUS  |     FLAGS     +
//       +-------+-------+-------+-------+
//     8 + DATA3 | DATA2 | DATA1 | DATA0 |
//       +-------+-------+-------+-------+
//    12 + DATA7 | DATA6 | DATA5 | DATA4 |
//       +-------+-------+-------+-------+
//
//  +-----------------------------------------+
//  |                  FLAGS                  |
//  +-----------+-----+-----+-----+-----+-----+
//  | 15 ...  5 |  4  |  3  |  2  |  1  |  0  |
//  +-----------+-----+-----+-----+-----+-----+
//  |  unused   | MGR | ERR | ACK | EXT | RTR |
//  +-----------+-----+-----+-----+-----+-----+
//
// CAN packet flags
//
#define CAN_RTR     1		// This is a Remote Transmit Request
#define CAN_EXT     2		// Extended ID packet
#define CAN_ACK     4		// Tx: Caller wants ACK packet on success. Rx: Locally generated ACK packet.
#define CAN_ERR     8		// Tx: Caller wants ERR packet on failure. Rx: Locally generated ERR packet.
#define CAN_MGR	   16		// Locally generated management packet
#define CAN_OVR	   32		// Overwrites already buffered packet with same ID
#define CAN_PSH	   64		// Tx: Push this to front of transmit queue
#define CAN_OSM   128		// Tx: Transmit only once, no retry on error
#define CAN_TICKS 256		// Tx: Put timestamp into CAN packet

/****************************************************************************************************************/
//
// Locally generated management packets
//
// IDENTIFIER: Event identifier, see below
// FLAGS:      CAN_MGR is set
// BUS:        Bus number
// LEN/DATA:   Optional event parameters
//

// Events reporting controller state
#define CAN_MGR_DISABLED	0x00	// Controller is disabled
#define CAN_MGR_OFFLINE		0x01	// Controller is not initialized
#define CAN_MGR_ONLINE		0x02	// Bus is working normally
#define CAN_MGR_WARN		0x03	// About to enter an error state
#define CAN_MGR_PASSIVE		0x04	// ERROR PASSIVE state
#define CAN_MGR_BUS_OFF		0x05	// BUS OFF state

/****************************************************************************************************************/
#endif
