#ifndef _CORE_CAN_H_ /*******************************************************************************************/
#define _CORE_CAN_H_

#include <core/canbits.h>

/****************************************************************************************************************/

struct can_packet {
  uint32 id;		// CAN identifier (11 or 29 bits)
  uint16 flags;		// RTR, EXT, ACK, ERR, etc... (see canbits.h)
  uint8 bus;		// Controller number
  uint8 len;		// Data length
  uint8 data[8];	// Data buffer
};

/****************************************************************************************************************/

struct can_mask {
  uint8 cm_version;	// Must be zero
  uint8 cm_bus;		// Selects bus controller number
  uint8 cm_index;	// Selects filter register index
  uint8 cm_pad;		// Unused
  uint32 cm_mask;	// Set filter mask
  uint32 cm_pattern;	// Set filter value
};

/****************************************************************************************************************/

struct can_speed {
  uint8 cs_version;	// Must be zero
  uint8 cs_bus;		// Selects bus controller number
  uint8 cs_pad1;	// Unused
  uint8 cs_pad2;	// Unused
  uint32 cs_speed;	// Speed in bits/second
};

/****************************************************************************************************************/
#endif
