#ifndef C4TAGS_H
#define C4TAGS_H

/*****************************************************************************************************************
 *
 * General configuration branch
 *
 */
#define C4S_GENERAL		0xFFC40000		/* General section					*/
#define C4T_GEN_DEVELOPMENT_MODE	0x02C40001	/* Enable development mode				*/
#define C4T_GEN_RESTRICT_DISCOVERY	0x02C40002	/* Disable discovery write access w/o debug jumper	*/
#define C4T_GEN_TIMEZONE		0x03C40003	/* Timezone string					*/
#define C4T_GEN_CLOCK			0x11C40004	/* CPU Clock						*/
#define C4T_GEN_PASSWORD		0x19C40005	/* Application password					*/
#define C4T_GEN_DISPLAY_ORIENTATION	0x10C40006	/* Default framebuffer orientation (90° steps)		*/
#define C4T_GEN_SYSTEM_NAME		0x03C40007	/* Arbitrary system name				*/
#define C4T_GEN_DISPLAY_SIZE		0x22C40008	/* Default framebuffer size hint			*/

/*****************************************************************************************************************
 *
 * Networking configuration branch
 *
 */
#define C4S_NETWORK		0xFFC40100		/* Network section					*/

#define C4T_NET_MODE			0x10C40100	/* Network mode						*/
#define C4T_NET_IP			0x14C40101	/* IP Address						*/
#define C4T_NET_NETMASK			0x14C40102	/* Network mask						*/
#define C4T_NET_GW			0x14C40103	/* Default gateway					*/
#define C4T_NET_BOOT_IP			0x14C40104	/* Boot source host for TFTP				*/
#define C4T_NET_BOOT_PATH		0x03C40105	/* Boot source filename for TFTP			*/
#define C4T_NET_BOOT_PORT		0x11C40106	/* Boot port number for TFTP				*/
#define C4T_NET_SYSLOG_IP		0x14C40107	/* IP Address of syslog server				*/
#define C4T_NET_APPSERVER_IP		0x14C40108	/* Application server IP address			*/
#define C4T_NET_APPSERVER_PORT		0x11C40109	/* Application server port number			*/
#define C4T_NET_APPSERVER_PATH		0x03C4010A	/* Path on application server (for building an URL)	*/
#define C4T_NET_APPSERVER_SCHEME	0x03C4010B	/* URL scheme for application server			*/
#define C4T_NET_LISTEN_IP		0x14C4010C	/* IP address to listen at for incoming connections	*/
#define C4T_NET_LISTEN_PORT		0x11C4010D	/* Port number to listen at for incoming connections	*/

/*
 * Enumeration values for C4T_NET_MODE
 */
#define C4E_NET_MODE_DISABLED	0			/* Networking disabled					*/
#define C4E_NET_MODE_DHCP	1			/* Configure by DHCP					*/
#define C4E_NET_MODE_STATIC	2			/* Static configuration					*/

#define C4E_NET_MODE_DEFAULT	C4E_NET_MODE_DHCP

/*****************************************************************************************************************
 *
 * Serial port branch
 *
 */
#define C4S_SERIAL		0xFFC402FF		/* Serial ports sections				*/

#define C4S_SER_TTYS0		0xFFC40200		/* One section for each port				*/
#define C4S_SER_TTYS1		0xFFC40201
#define C4S_SER_TTYS2		0xFFC40202
#define C4S_SER_TTYS3		0xFFC40203
#define C4S_SER_TTYS4		0xFFC40204
#define C4S_SER_TTYS5		0xFFC40205
#define C4S_SER_TTYS6		0xFFC40206
#define C4S_SER_TTYS7		0xFFC40207
#define C4S_SER_TTYS8		0xFFC40208
#define C4S_SER_TTYS9		0xFFC40209
#define C4S_SER_TTYS10		0xFFC4020A
#define C4S_SER_TTYS11		0xFFC4020B
#define C4S_SER_TTYS12		0xFFC4020C
#define C4S_SER_TTYS13		0xFFC4020D
#define C4S_SER_TTYS14		0xFFC4020E
#define C4S_SER_TTYS15		0xFFC4020F
#define C4S_SER_TTYS16		0xFFC40210
#define C4S_SER_TTYS17		0xFFC40211
#define C4S_SER_TTYS18		0xFFC40212
#define C4S_SER_TTYS19		0xFFC40213
#define C4S_SER_TTYS20		0xFFC40214
#define C4S_SER_TTYS21		0xFFC40215
#define C4S_SER_TTYS22		0xFFC40216
#define C4S_SER_TTYS23		0xFFC40217
#define C4S_SER_TTYS24		0xFFC40218
#define C4S_SER_TTYS25		0xFFC40219
#define C4S_SER_TTYS26		0xFFC4021A
#define C4S_SER_TTYS27		0xFFC4021B
#define C4S_SER_TTYS28		0xFFC4021C
#define C4S_SER_TTYS29		0xFFC4021D
#define C4S_SER_TTYS30		0xFFC4021E
#define C4S_SER_TTYS31		0xFFC4021F

#define C4T_SER_SPEED		0x11C40200		/* Port speed						*/

/*****************************************************************************************************************
 *
 * Display configuration branch
 *
 */
#define C4S_DISPLAY		0xFFC403FF		/* Display section					*/

#define C4T_DISPLAY_TOUCH		0x00C40300	/* Touch calibration					*/
#define C4T_DISPLAY_TFP410_DESKEW	0x11C40301	/* TFP410 deskew initial value				*/

/****************************************************************************************************************/
#endif
