#ifndef _TT_ROTATE_H_
#define _TT_ROTATE_H_

/****************************************************************************************************************/

__attribute__((__always_inline__)) static inline unsigned int ror(unsigned int val, unsigned int shift) {
  unsigned int result;

#ifdef THUMB

  asm("ror %[result], %[val], %[shift]"

      : [result] "=l"  (result)

      : [val]    "0"   (val),
        [shift]  "l"  (shift));

#else

  asm("mov %[result], %[val], ror %[shift]"

      : [result] "=r"  (result)

      : [val]    "r"   (val),
        [shift]  "ir"  (shift));

#endif

  return result;
}

/****************************************************************************************************************/

__attribute__((__always_inline__)) static inline unsigned int rol(unsigned int val, unsigned int shift) {
  unsigned int result;

  shift = 32 - shift;

#ifdef THUMB

  asm("ror %[result], %[val], %[shift]"

      : [result] "=l"  (result)

      : [val]    "0"   (val),
        [shift]  "l"  (shift));

#else

  asm("mov %[result], %[val], ror %[shift]"

      : [result] "=r"  (result)

      : [val]    "r"   (val),
        [shift]  "ir"  (shift));

#endif

  return result;
}

/****************************************************************************************************************/
#endif
