#ifndef TT_PTTQ_H /*********************************************************************************************/
#define TT_PTTQ_H

/****************************************************************************************************************/
//
// Polltable and timers go together well
//
#include <tt/polltable.h>
#include <tt/timer.h>
#include <tt/macros.h>
#include <sys/cdefs.h>

/****************************************************************************************************************/

struct pttq {
  struct polltable *pt;
  struct timerqueue *tq;
};

/****************************************************************************************************************/

static _inline int pttq_poll(struct pttq *pttq) {
  int maxms = timerqueue_checkpoint(pttq->tq);
  int result = ptab_poll(pttq->pt, maxms);
  timerqueue_checkpoint(pttq->tq);
  return result;
}

__BEGIN_DECLS
int pttq_init(struct pttq *pttq, unsigned int max_fds);
void pttq_release(struct pttq *pttq);
__END_DECLS

/****************************************************************************************************************/
#endif
