#ifndef _SYS_TIME_H_ /*******************************************************************************************/
#define _SYS_TIME_H_

/****************************************************************************************************************/

#include <core/time.h>
#include <core/syscall/time.h>
#include <sys/cdefs.h>

/****************************************************************************************************************/

// Note: tz value not used, but here for compatibility
struct timezone;

__BEGIN_DECLS
extern int gettimeofday(struct timeval *tv, struct timezone *tz);
extern int settimeofday(const struct timeval *tv, const struct timezone *tz);
__END_DECLS

/****************************************************************************************************************/

#define timerisset(tv)		((tv)->tv_sec || (tv)->tv_usec)
#define timercmp(tv, uvp, cmp)	((tv)->tv_sec cmp (uvp)->tv_sec || ((tv)->tv_sec == (uvp)->tv_sec && \
				 (tv)->tv_usec cmp (uvp)->tv_usec))
#define timerclear(tv)		((tv)->tv_sec = (tv)->tv_usec = 0)

#define timeradd(tvp, uvp, vvp)                                         \
        do {                                                            \
                (vvp)->tv_sec = (tvp)->tv_sec + (uvp)->tv_sec;          \
                (vvp)->tv_usec = (tvp)->tv_usec + (uvp)->tv_usec;       \
                if ((vvp)->tv_usec >= 1000000) {                        \
                        (vvp)->tv_sec++;                                \
                        (vvp)->tv_usec -= 1000000;                      \
                }                                                       \
        } while (0)

#define timersub(tvp, uvp, vvp)                                         \
        do {                                                            \
                (vvp)->tv_sec = (tvp)->tv_sec - (uvp)->tv_sec;          \
                (vvp)->tv_usec = (tvp)->tv_usec - (uvp)->tv_usec;       \
                if ((vvp)->tv_usec < 0) {                               \
                        (vvp)->tv_sec--;                                \
                        (vvp)->tv_usec += 1000000;                      \
                }                                                       \
        } while (0)

/****************************************************************************************************************/
#endif
