#ifndef _SIGNAL_H_
#define _SIGNAL_H_

/****************************************************************************************************************/

#include <sys/types.h>
#include <sys/cdefs.h>
#include <core/signal.h>
#include <core/syscall/signal.h>

__BEGIN_DECLS

/****************************************************************************************************************/

extern const char *const sys_signame[NSIG];

/****************************************************************************************************************
 *
 * Library functions
 *
 */
sighandler_t signal(int signum, sighandler_t handler);

int sigemptyset(sigset_t *set);
int sigfillset(sigset_t *set);
int sigaddset(sigset_t *set, int signum);
int sigdelset(sigset_t *set, int signum);
int sigismember(const sigset_t *set, int signum);

int siginterrupt(int sig, int flag);

/****************************************************************************************************************
 *
 * Old bsd style API (Do not use in new programs)
 *
 */
struct sigvec {
  void (*sv_handler)(int);	/* Signal disposition */
  int    sv_mask;		/* Signals to be blocked in handler */
  int    sv_flags;		/* Flags */
};

#define SV_ONSTACK	SA_ONSTACK
#define SV_INTERRUPT	SA_RESTART	/* same bit, opposite sense */
#define SV_RESETHAND	SA_RESETHAND
#define sv_onstack	sv_flags

int sigvec(int sig, struct sigvec *vec, struct sigvec *ovec);
int sigmask(int signum);
int sigblock(int mask);
int sigsetmask(int mask);
int siggetmask(void);

/****************************************************************************************************************
 *
 * Actual system calls
 *
 */
__attribute__((__always_inline__)) static inline int killpg(pid_t pgrp, int signo) { return kill(-pgrp, signo); }

/****************************************************************************************************************/

__END_DECLS
#endif
