#ifndef CONFIGMGR_H /***************************************************************************** -*- c++ -*- **/
#define CONFIGMGR_H

/****************************************************************************************************************/

class ConfigFile;

class ConfigManager {
public:
  ConfigManager();
  ~ConfigManager();

  void setCfgFilename(const char *txt);
  const char *cfgFilename(void) const;
  const char *fullCfgFilename(void);

  ConfigFile *cfg(void) { return m_cfg; }

  ConfigFile *loadConfigFile(void);
  bool modified(void);
  bool saveConfigFile(void);
  bool saveIfModified(void);

  void clear(void); // Clears file, keeps filename

public:
  static void setCfgPath(const char *txt);
  static const char *cfgPath(void);

private:
  static char *m_cfg_path;

  ConfigFile *m_cfg;

  char *m_cfg_filename;
  char *m_cfg_full_filename;
};

/****************************************************************************************************************/

#endif
