#ifndef _CORE_WATCHDOG_H_
#define _CORE_WATCHDOG_H_

#include <core/types.h>
#include <core/watchdogbits.h>

/****************************************************************************************************************/

struct watchdog_info {
  uint32 options;			// Supported options (Zero or more of WDIOC_...)
  uint32 firmware_version;		// Not used on Core4
  char identity[32];			// Identification of watchdog hardware
};

/****************************************************************************************************************/

struct watchdog_options {
  uint32 timeout;			// Time after which watchdog triggers (ms)
  uint32 pretimeout;			// Time that must elapse before another keepalive is accepted (ms)
  uint32 options;			// Not used
  uint32 flags;				// Not used
};

/****************************************************************************************************************/
#endif
