#ifndef TTND_TAP_H
#define TTND_TAP_H
/****************************************************************************************************************/

#include <stdint.h>

struct ttn_tap_device_t;
struct ttn_bridge_handle_t;

struct ttn_tap_device_t *ttn_tap_open(const char *interface, const uint8_t *mac, struct ttn_bridge_handle_t *ttb);
void ttn_tap_close(struct ttn_tap_device_t *dev);

int ttn_tap_get_fd(struct ttn_tap_device_t *dev);
const uint8_t *ttn_tap_get_mac(struct ttn_tap_device_t *dev);

struct ttn_pkb_t;
enum TTNProcessingResult ttn_tap_transmit(struct ttn_tap_device_t *dev, struct ttn_pkb_t *pkb);

void ttn_tap_receive(struct ttn_tap_device_t *dev);

/****************************************************************************************************************/
#endif
