#ifndef _CORE_SYSCALL_UNISTD_H_ /********************************************************************************/
#define _CORE_SYSCALL_UNISTD_H_

/****************************************************************************************************************/

#include <core/types.h>
#include <core/syscall.h>

#ifdef __CORE4_VISIBLE
_syscall2(void, writek, const void *, ptr, size_t, len);
_syscall2(int, _sync, int, fd, int, flags);
#endif

_syscall1(int, close, int, fd);
_syscall3(ssize_t, read,  int, fd, void *, buf, size_t, count);
_syscall4(ssize_t, pread,  int, fd, void *, buf, size_t, count, off_t, offset);
_syscall3(ssize_t, write, int, fd, const void *, buf, size_t, count);
_syscall4(ssize_t, pwrite,  int, fd, const void *, buf, size_t, count, off_t, offset);
_syscall3(off_t, lseek, int, fd, off_t, ofs, int, whence);
_syscall1(int, dup, int, oldfd);
_syscall2(int, dup2, int, oldfd, int, newfd);
_syscall2(int, _pipe, int *, filedes, int, bidir);
_syscall2(int, access, const char *, pathname, int, mode);
_syscall3(int, readlink, const char *, pathname, char *, buf, size_t, bufsiz);
_syscall4(int, readlinkat, int, dirfd, const char *, pathname, char *, buf, size_t, bufsiz);
_syscall1(int, rmdir, const char *, pathname);
_syscall2(int, symlink, const char *, oldpath, const char *, newpath);
_syscall2(int, link, const char *, oldpath, const char *, newpath);
_syscall1(int, unlink, const char *, name);
_syscall1(int, chdir, const char *, path);
_syscall2(int, getchdir, char *, buf, size_t, bufsize);
_syscall1(int, fchdir, int, fd);
_syscall1(int, chroot, const char *, path);
_syscall0(pid_t, vfork);
_syscall0(pid_t, fork);
_syscall2(int, truncate, const char *, pathname, off_t, len);
_syscall2(int, ftruncate, int, fd, off_t, len);

_syscall0(pid_t, getpid);
_syscall0(pid_t, getppid);
_syscall3(int, execve, const char *, filename, char * const *, argv, char *const *, envp);

_syscall1(long, _sysconf, int, name);

_syscall2(useconds_t, ualarm, useconds_t, usec, useconds_t, interval);

_syscall2(int, setpgid, pid_t, pid, pid_t, pgid);
_syscall1(pid_t, getpgid, pid_t, pid);
_syscall0(pid_t, setsid);

_syscall1(int, setuid, uid_t, uid);
_syscall1(int, seteuid, uid_t, uid);
_syscall2(int, setreuid, uid_t, ruid, uid_t, euid);
_syscall0(int, getuid);
_syscall0(int, geteuid);

_syscall1(int, setgid, gid_t, gid);
_syscall1(int, setegid, gid_t, gid);
_syscall2(int, setregid, gid_t, rgid, gid_t, egid);
_syscall0(int, getgid);
_syscall0(int, getegid);
_syscall2(int, getgroups, int, size, gid_t *, list);
_syscall2(int, setgroups, int, size, const gid_t *, list);

/****************************************************************************************************************/
#endif
