#ifndef _CORE_GPIOBITS_H_ /**** USED BY LUA *********************************************************************/
#define _CORE_GPIOBITS_H_

/****************************************************************************************************************/
//
// <type> field for general purpose IO
//
// Note: Mapping ON/OFF level to HI/LO depends on hardware.
//
#define GPIO_OUT_OFF		0x00	// Set pin to output and drive to OFF level
#define GPIO_OUT_ON		0x01	// Set pin to output and drive to ON level
#define GPIO_OUT_SET		0x02	// Set pin to output and drive to <value> level
#define GPIO_OUT_GET		0x03	// Return current state of pin inside <value> field
#define GPIO_OUT_BLINK		0x04	// Set pin to output and drive pattern from <value> field
#define GPIO_OUT_PULSE		0x05	// Set pin to output and drive ON for <value> µs, then OFF
#define GPIO_OUT_PULSE_INV	0x06	// Set pin to output and drive OFF for <value> µs, then ON
#define GPIO_OUT_PWM		0x07	// Set pin to output and drive PWM
#define GPIO_OUT_PWM_INV	0x08	// Set pin to output and drive inverted PWM

#define GPIO_INP_GET		0x10	// Set pin to input, return current state of pin inside <value> field
#define GPIO_INP_DEBOUNCE	0x11	// Set pin to input, return debounced state of pin inside <value> field

#define GPIO_WATCH		0x20	// Set up pin state change notification
#define GPIO_PAUSE		0x21	// Wait for <value> ms before continueing

#define GPIO_EDGE		0x30	// Return current state of edge counters
#define GPIO_FALLING		0x31	// Pin change report: Falling edge detected, pin is off
#define GPIO_RISING		0x32	// Pin change report: Rising edge detected, pin is on
#define GPIO_OFF		0x33	// Pin change report: Update of unchanged edge count, pin is off
#define GPIO_ON			0x34	// Pin change report: Update of unchanged edge count, pin is on

#define GPIO_INACTIVE		0x40	// A polled node has gone active, pin value reports group of polled node
#define GPIO_ACTIVE		0x41	// Ditto, node is no longer active

#define GPIO_PAY		0x50	// Payout command to a hopper controller
#define GPIO_PAYING		0x51	// Informational event from hopper controller
#define GPIO_PAID		0x52	// Payout command completion event
#define GPIO_PAYFAIL		0x54	// Payout command failed to complete

#define GPIO_LIMIT		0x60	// Control motor with limit switch

/****************************************************************************************************************/
//
// <value> field for <type> == GPIO_WATCH
//
#define GPIO_WATCH_NONE		0	// Do not report pin state change
#define GPIO_WATCH_FALLING	1	// Report when pin changes ON -> OFF
#define GPIO_WATCH_RISING	2	// Report when pin changes OFF -> ON
#define GPIO_WATCH_ANY		3	// Report any change

/****************************************************************************************************************/
//
// Values for <group> field
//
// There are several generic peripherals listed here.
// This makes it possible to be notified about state changes of those peripherals.
//
#define GPGRP_NONE		0	// Dummy value, no pin
#define GPGRP_DIP		1	// Generic DIP switch
#define GPGRP_TTY		2	// RTS,CTS,DTR,DSR,RI,DCD direct access
#define GPGRP_USB		3	// Port connected, overcurrent, powered
#define GPGRP_LAN		4	// Link state, speed, duplex
#define GPGRP_GPIO		5	// Generic on board GPIO pins
#define GPGRP_STORAGE		6	// Storage card inserted, storage card write protected
#define GPGRP_AUDIO		7	// Speaker/Headphone/whatever connected, call button pressed, ...
#define GPGRP_SIDEKICK		8	// Sidekick processor GPIO
#define GPGRP_MUPP		9	// MUPP/MBUS behind a tty
#define GPGRP_LED		10	// LED control
#define GPGRP_CAN		11	// CAN bus controller extra GPIO pins
#define GPGRP_BACKPLANE		12	// Display backplane

/****************************************************************************************************************/
#endif
