#ifndef POLLTABLE_H /********************************************************************************************/
#define POLLTABLE_H

/****************************************************************************************************************/

#include <sys/poll.h>
#include <sys/cdefs.h>
#include <stdlib.h>

/****************************************************************************************************************/

struct polltable;
typedef int pollcallback_t(int fd, int revents, void *data);

/****************************************************************************************************************
 *
 * Return values for ptab_poll()
 *
 */
#define PTPR_SUCCESS	0
#define PTPR_ERROR	-1
#define PTPR_MAXNEST	-2

/****************************************************************************************************************/

__BEGIN_DECLS

// Alloc/free
struct polltable *ptab_alloc(unsigned int max);
void ptab_free(struct polltable *ptab);

// Interface
struct pollitem;

struct pollitem *ptab_add(struct polltable *ptab, int fd, int events, pollcallback_t *cb, void *data);

void ptab_rem(struct pollitem *pi);

void ptab_disable(struct pollitem *pi);
void ptab_enable(struct pollitem *pi);
void ptab_set_events(struct pollitem *pi, int events);
void ptab_set_debug(struct pollitem *pi, int flags);
void ptab_set_ptab_debug(struct polltable *ptab, uint flags);

int ptab_get_enabled(struct pollitem *pi);
int ptab_get_events(struct pollitem *pi);
int ptab_get_debug(struct pollitem *pi);
int ptab_get_fd(struct pollitem *pi);
int ptab_get_busy(struct pollitem *pi);

int ptab_poll(struct polltable *ptab, int timeout);

int ptab_poll_start(struct polltable *ptab, int timeout);
void ptab_poll_finish(struct polltable *ptab);
void ptab_reset(struct polltable *ptab);

// Debug
void ptab_dump(struct polltable *ptab);

__END_DECLS

/****************************************************************************************************************/
#endif
