/* $OpenBSD: limits.h,v 1.7 2007/05/07 15:29:44 millert Exp $ */
/*
 * Copyright (c) 2002 Marc Espie.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE OPENBSD PROJECT AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OPENBSD
 * PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Modified from OpenBSD original by Teratronik.
 *
 */
#ifndef _SYS_LIMITS_H_
#define _SYS_LIMITS_H_

#include <sys/cdefs.h>

// Include gcc's limits
#include <limits.h>

/* Common definitions for limits.h. */

#define NL_TEXTMAX              255

#define	CHAR_BIT	8		/* number of bits in a char */

#define	SCHAR_MAX	0x7F		/* max value for a signed char */
#define SCHAR_MIN	(-0x7F-1)	/* min value for a signed char */

#define	UCHAR_MAX	0xFF		/* max value for an unsigned char */
#define CHAR_MAX	0x7F		/* min value for a char */
#define CHAR_MIN	(-0x7F-1)	/* max value for a char */

#define	USHRT_MAX	0xFFFF		/* max value for an unsigned short */
#define	SHRT_MAX	0x7FFF		/* max value for a short */
#define SHRT_MIN        (-0x7FFF-1)     /* min value for a short */

#define	UINT_MAX	0xFFFFFFFFU	/* max value for an unsigned int */
#define	INT_MAX		0x7FFFFFFF	/* max value for an int */
#define	INT_MIN		(-0x7FFFFFFF-1)	/* min value for an int */

#define ULONG_MAX	0xFFFFFFFFUL	/* max value for an unsigned long */
#define LONG_MAX	0x7FFFFFFFL	/* max value for a long */
#define LONG_MIN	(-0x7FFFFFFFL-1)/* min value for a long */

#define ULLONG_MAX	0xFFFFFFFFFFFFFFFFULL	
					/* max value for unsigned long long */
#define LLONG_MAX	0x7FFFFFFFFFFFFFFFLL	
					/* max value for a signed long long */
#define LLONG_MIN	(-0x7FFFFFFFFFFFFFFFLL-1)	
					/* min value for a signed long long */

#define UID_MAX	UINT_MAX		/* max value for a uid_t */
#define GID_MAX	UINT_MAX		/* max value for a gid_t */

#define LONG_BIT	32
#define WORD_BIT	32

// Include teratronik limits, also
#include <core/limits.h>
#include <core/param.h>
#endif
