#ifndef _STRING_H_
#define _STRING_H_

/****************************************************************************************************************/

#include <sys/types.h>
#include <sys/cdefs.h>

__BEGIN_DECLS

int strcmp(const char *s1, const char *s2) __attribute__((nonnull));
int strncmp(const char *s1, const char *s2, size_t n) __attribute__((nonnull));
size_t strlen(const char *s) __attribute__((nonnull));
size_t strnlen(const char *s, size_t n) __attribute__((nonnull));
char *strcpy(char *dest, const char *src) __attribute__((nonnull));
char *stpcpy(char *dest, const char *src) __attribute__((nonnull));
char *strncpy(char *dest, const char *src, size_t n) __attribute__((nonnull));
char *strcat(char *dest, const char *src) __attribute__((nonnull));
char *strncat(char *dest, const char *src, size_t n) __attribute__((nonnull));
char *strdup(const char *s) __attribute__((nonnull));
char *strndup(const char *s, size_t n) __attribute__((nonnull));

char *strchr(const char *s, int c) __attribute__((nonnull));
char *strchrnul(const char *s, int c) __attribute__((nonnull));
char *strrchr(const char *s, int c) __attribute__((nonnull));

char *strsep(char **stringp, const char *delim) __attribute__((nonnull));

int strcasecmp(const char *s1, const char *s2) __attribute__((nonnull));
int strncasecmp(const char *s1, const char *s2, size_t n) __attribute__((nonnull));

int strcoll(const char *s1, const char *s2) __attribute__((nonnull));
size_t strxfrm(char *dest, const char *src, size_t n) __attribute__((nonnull));

char *strstr(const char *s, const char *find) __attribute__((nonnull));
char *strcasestr(const char *s, const char *find) __attribute__((nonnull));

void *memset(void *s, int c, size_t n);
void *memcpy(void *dest, const void *src, size_t n);
void *mempcpy(void *dest, const void *src, size_t n);
void *memmove(void *dest, const void *src, size_t n);
int memcmp(const void *s1, const void *s2, size_t n) __attribute__((nonnull));
void *memchr(const void *s, int c, size_t n) __attribute__((nonnull));
void *memrchr(const void *s, int c, size_t n) __attribute__((nonnull));
void *memmem(const void *haystack, size_t haystacklen, const void *needle, size_t needlelen)
     __attribute__((nonnull));

// Courtesy of OpenBSD
size_t strlcat(char *dst, const char *src, size_t siz);
size_t strlcpy(char *dst, const char *src, size_t siz);

size_t strspn(const char *s, const char *accept);
size_t strcspn(const char *s, const char *reject);
char *strpbrk(const char *s, const char *accept);

char *strtok(char *s, const char *delim);
char *strtok_r(char *s, const char *delim, char **last);

/***************************************************************************************************************/

char *strerror(int errnum);
int strerror_r(int errnum, char *buf, size_t buflen);

extern const int sys_nerr;
extern const char *const sys_errlist[];

/***************************************************************************************************************/

char *strsignal(int sig);

extern const char *const sys_signame[];
extern const char *const sys_siglist[];

/****************************************************************************************************************/

#ifndef NULL
#define NULL 0L
#endif

/****************************************************************************************************************/

void strmode(int mode, char *p);

#ifdef __CORE4_VISIBLE
void strmode_short(int mode, char *p);
#endif

/****************************************************************************************************************/
__END_DECLS
#endif
