#ifndef _RASTER_BLEND_H_
#define _RASTER_BLEND_H_

#include <core/cdefs.h>
#include <core/types.h>

/****************************************************************************************************************/
//
// Alpha blend source with destination.
//
// <rgb_src> is value to be blended in.
// <alpha>   is transparency information: 255=dst only, 0=src only, or anything blended inbetween.
// <rgb_dst> is the previous value at the destination, without alpha information.
//
// Returns alpha blended RGB value for destination.
//
// Fixme: This divides by 256, but should divide by 255. Find out trick to get rid of rounding error.
//
static __inline uint alpha_blend(uint rgb_src, uint alpha, uint rgb_dst) {
  uint rgb;

  // Can do RED and BLUE together
  uint srb = rgb_src & 0x00FF00FF;
  uint drb = rgb_dst & 0x00FF00FF;
  rgb  = (((0x800080 + alpha * (drb - srb)) >> 8) + srb) & 0x00FF00FF;

  // Now for GREEN, also.
  uint sg = rgb_src & 0x0000FF00;
  uint dg = rgb_dst & 0x0000FF00;
  rgb += (((0x008000 + alpha * (dg - sg)) >> 8) + sg) & 0x0000FF00;

  return rgb;
}

/****************************************************************************************************************/
#endif
