#ifndef VK_OSDEP_H
#define VK_OSDEP_H

/****************************************************************************************************************/
//
// Windows
//
#if defined(WIN32)

typedef unsigned char  uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long  uint32_t;

typedef signed char    int8_t;
typedef signed short   int16_t;
typedef signed long    int32_t;

#include <string.h>

#define VK_INLINE static

VK_INLINE void *mempcpy(void *dst, const void *src, size_t n) {
  memcpy(dst, src, n);
  return ((char *)dst) + n;
}

#include "atoi.h"

/****************************************************************************************************************/
//
// Core 4
//
#elif defined(_CORE4_)

#define HAVE_LIBTEXT

#define VK_INLINE static inline

#include <stdint.h>
#include <sys/types.h>
#include <string.h>

#include <text/atoi.h>

/****************************************************************************************************************/
//
// Linux
//
#elif defined(linux)

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#define VK_INLINE static inline

#include <stdint.h>
#include <sys/types.h>
#include <string.h>

#include "atoi.h"

/****************************************************************************************************************/
//
// Embedded
//
#else

#define HAVE_LIBTEXT

#define VK_INLINE static inline

#include <stdint.h>
#include <sys/types.h>
#include <string.h>
#include <atoi.h>

VK_INLINE void *mempcpy(void *dst, const void *src, size_t n) {
  memcpy(dst, src, n);
  return ((char *)dst) + n;
}

#define VK_HIDE_STATE_NAMES
#define VK_HIDE_ERROR_NAMES
//#define VK_HIDE_PROTO_TRACE

#endif

/****************************************************************************************************************/
#endif
