#ifndef TIMERQUEUE_H /**************************************************************************** -*- c++ -*- **/
#define TIMERQUEUE_H

/****************************************************************************************************************/

#include "timer.h"

#include <sys/time.h>

/****************************************************************************************************************/

class Timer;

class TimerQueue : public Object {
public:
  TimerQueue(Object *par = 0, const char *n = 0);
  ~TimerQueue();

public:
  void setTimer(Timer *timer);
  void remTimer(Timer *timer);

  bool checkpoint(const struct timeval &tv);
  int timeLeft(const struct timeval &tv);

public:
  virtual void dump(unsigned int spaces = 0);
  virtual void dumpTimers(unsigned int spaces = 0);

private:
  Timer *m_first;
};

/****************************************************************************************************************/

extern TimerQueue AppTimerQueue;

/****************************************************************************************************************/

#endif
