#ifndef _CTYPE_H_
#define _CTYPE_H_

/****************************************************************************************************************/

#include <sys/types.h>
#include <sys/cdefs.h>

#define	_U	0x01
#define	_L	0x02
#define	_N	0x04
#define	_S	0x08
#define _P	0x10
#define _C	0x20
#define _X	0x40
#define	_B	0x80

__BEGIN_DECLS

extern const char *_ctype_;
extern const short *_tolower_tab_;
extern const short *_toupper_tab_;

__END_DECLS

/****************************************************************************************************************/

#define __DECLARE_CTYPE_LOOKUP(name, mask)	\
  static __inline int name(int c) {		\
    if ((unsigned int)c > 255) return 0;	\
    return _ctype_[(unsigned int)(c)]&(mask);	\
  }

__DECLARE_CTYPE_LOOKUP(isalpha, _U|_L)
__DECLARE_CTYPE_LOOKUP(isupper, _U)
__DECLARE_CTYPE_LOOKUP(islower, _L)
__DECLARE_CTYPE_LOOKUP(isdigit, _N)
__DECLARE_CTYPE_LOOKUP(isxdigit, _X|_N)
__DECLARE_CTYPE_LOOKUP(isspace, _S)
__DECLARE_CTYPE_LOOKUP(isblank, _B)
__DECLARE_CTYPE_LOOKUP(ispunct, _P)
__DECLARE_CTYPE_LOOKUP(isalnum, _U|_L|_N);
__DECLARE_CTYPE_LOOKUP(isprint, _P|_U|_L|_N|_B);
__DECLARE_CTYPE_LOOKUP(isgraph, _P|_U|_L|_N);
__DECLARE_CTYPE_LOOKUP(iscntrl, _C);

static __inline int isascii(int c) { return (unsigned int)c < 128; }

/****************************************************************************************************************/

static __inline int tolower(int c) {
  if ((unsigned int)c > 255) return c;
  return _tolower_tab_[(unsigned int)(c)];
}

static __inline int toupper(int c) {
  if ((unsigned int)c > 255) return c;
  return _toupper_tab_[(unsigned int)(c)];
}

static __inline int toascii(int c) {
  return c & 0x7F;
}

/****************************************************************************************************************/
#endif
