#ifndef LIBTTN_LNK_MACTABLE_H
#define LIBTTN_LNK_MACTABLE_H
/****************************************************************************************************************/

#include "ttn/ttn.h"
#include "ttn/lnk/pkb.h"

/****************************************************************************************************************/
//
// Keeping track of addresses that go together.
//
struct ttn_mac_item_t {
  struct list_head mi_list;
  uint32_t mi_timestamp;                        // Aging timer
  uint32_t mi_ip;				// IP address of cached entry
  uint8_t mi_mac[6];				// MAC address of cached entry
  uint8_t mi_tid;                               // Non-zero if this device is on the TTN
};

struct ttn_mac_cache_t {
  struct list_head mac_used;
  struct list_head mac_free;
  unsigned int mac_tracelevel;
  struct ttn_mac_item_t mac_cache[TTN_CONFIG_MAC_CACHE_COUNT];
};

/****************************************************************************************************************/

void ttn_mactable_init(struct ttn_mac_cache_t *mtb);
void ttn_mactable_reset(struct ttn_mac_cache_t *mtb);
void ttn_mactable_prune(struct ttn_mac_cache_t *mtb);

#define TTN_MACTABLE_KEEP_IP  0
struct ttn_mac_item_t *ttn_mactable_save(struct ttn_mac_cache_t *mtb, const uint8_t *mac, uint32_t ip, unsigned int tid);

struct ttn_mac_item_t *ttn_mactable_touch_ip(struct ttn_mac_cache_t *mtb, uint32_t ip);
void ttn_mactable_touch(struct ttn_mac_cache_t *mtb, struct ttn_mac_item_t *item);

struct ttn_mac_item_t *ttn_mactable_find_ip(struct ttn_mac_cache_t *mtb, uint32_t ip);
struct ttn_mac_item_t *ttn_mactable_find_mac(struct ttn_mac_cache_t *mtb, const uint8_t *mac);
struct ttn_mac_item_t *ttn_mactable_find_tid(struct ttn_mac_cache_t *mtb, unsigned int tid);

static inline void ttn_mactable_set_tracelevel(struct ttn_mac_cache_t *mtb, unsigned int tl) {
  mtb->mac_tracelevel = tl;
}

static inline unsigned int ttn_mactable_tracelevel(struct ttn_mac_cache_t *mtb) {
  return mtb->mac_tracelevel;
}

/****************************************************************************************************************/
#endif
