#ifndef _CORE_FCNTL_H_
#define _CORE_FCNTL_H_

#include <core/fcntlbits.h>
#include <core/types.h>

/*
 * Advisory file segment locking data type -
 * information passed to system by user
 */
struct flock {
  off_t	  l_start;	/* starting offset			*/
  off_t	  l_len;	/* len = 0 means until end of file	*/
  pid_t	  l_pid;	/* lock owner				*/
  short	  l_type;	/* lock type: read/write, etc.		*/
  short	  l_whence;	/* type of l_start			*/
};

#endif
