#ifndef _CORE_EDID_H_
#define _CORE_EDID_H_

/****************************************************************************************************************/

#include <core/types.h>
#include <core/modeline.h>

/****************************************************************************************************************/
//
// Teratronik proprietary backplane controller information
//
#define EDID_CONTROL_FEATURE_BACKLIGHT		(1<<0)
#define EDID_CONTROL_FEATURE_CONTRAST		(1<<1)
#define EDID_CONTROL_FEATURE_BRIGHTNESS		(1<<2)

#define EDID_DEVICE_FEATURE_TOUCH		(1<<0)
#define EDID_DEVICE_FEATURE_KEYPAD		(1<<1)

struct fbdev_backplane_version {
  uint   bv_structure_size;		// Size of the structure
  char   bv_version[32];		// Version string
  char   bv_serial_number[32];		// Serial number string
  time_t bv_manufacture_date;		// Manufacture date
  time_t bv_build_date;			// Firmware build date
  uint32 bv_control_features;		// Control feature bits: backlight, contrast, brightness, ...
  uint32 bv_device_features;		// Device feature bits:  touch screen, keypad, ...
  uint8  bv_tty_count;			// Number of supported tty tunnels
  uint8  bv_output_count;		// Number of additional GPIO outputs
  uint8  bv_input_count;		// Number of additional GPIO inputs
};

/****************************************************************************************************************/

#define EDID_DPMS_STANDBY		128
#define EDID_DPMS_SUSPEND		64
#define EDID_DPMS_OFF			32

#define EDID_FEATURE_SRGB		4
#define EDID_FEATURE_PREFERRED_TIMING	2
#define EDID_FEATURE_GTF		1

/****************************************************************************************************************/
// Second version -- has fixed resolution fields

struct fbdev_edid {
  // Header
  unsigned int structure_size;		// Size of the structure

  // Product identification
  char manufacturer[4];			// Three-letter manufacturer code
  uint32 serial_number;			// Serial number
  uint16 product_code;			// Manufacturer assigned unique product-type identifier
  uint16 year_made;			// Manufacturing year (If week_made is 255, then instead: Model year)
  uint8 week_made;			// Manufacturing year (255 if not used)

  // Product properties
  uint8 feature_flags;			// Flags for standby support, etc...
  uint16 physical_width;		// Physical size of display in mm
  uint16 physical_height;

  // Modelines
  uint modeline_count;			// Number of saved modelines
  struct fbdev_modeline modelines[24];	// Modeline data

  // Descriptors
  char name[16];			// Display name
  char serial_number_text[16];		// Serial number text
  char text[16];			// Unspecified text

  // Frequency range
  uint8 vmin, vmax;			// Vertical frequency range (Hz)
  uint8 hmin, hmax;			// Horizontal frequency range (kHz)
  uint  pclkmax;			// Max pixel clock (Hz)

  // Fixed resolution
  uint fixed_width, fixed_height;
};

/****************************************************************************************************************/
#endif
