#ifndef SHA_H
#define SHA_H

/****************************************************************************************************************/

#include "types.h"

/****************************************************************************************************************/

struct sha256_state {
  uint32 opaque[26];
};

void sha224_init(struct sha256_state *state);
void sha224(struct sha256_state *state, unsigned int ch);
void sha224_update(struct sha256_state *state, const void *ptr, unsigned int count);
const void *sha224_final(struct sha256_state *state);

void sha256_init(struct sha256_state *state);
void sha256(struct sha256_state *state, unsigned int ch);
void sha256_update(struct sha256_state *state, const void *ptr, unsigned int count);
const void *sha256_final(struct sha256_state *state);

/****************************************************************************************************************/

struct sha512_state {
  uint32 opaque[68];
};

void sha384_init(struct sha512_state *state);
void sha384(struct sha512_state *state, unsigned int ch);
void sha384_update(struct sha512_state *state, const void *ptr, unsigned int count);
const void *sha384_final(struct sha512_state *state);

void sha512_init(struct sha512_state *state);
void sha512(struct sha512_state *state, unsigned int ch);
void sha512_update(struct sha512_state *state, const void *ptr, unsigned int count);
const void *sha512_final(struct sha512_state *state);

/****************************************************************************************************************/
#endif
