#ifndef _TOOLS_CPU_H_ /******************************************************************************************/
#define _TOOLS_CPU_H_

#include <sys/cdefs.h>

/****************************************************************************************************************/

#ifdef THUMB

__BEGIN_DECLS
int swap_arm(volatile void *ptr, int val);	// Atomically reads *var and replaces it with val.
__END_CDECLS

#define swap(var, val)		swap_arm(var, val)

/****************************************************************************************************************/

#else /* ARM code */

static inline unsigned int swap(volatile void *ptr, unsigned int in) {
  unsigned int out;
  asm volatile("swp %[out],%[in],[%[ptr]]" : [out] "=&r"(out) : [in] "r"(in), [ptr] "r" (ptr));
  return out;
}

#endif

/****************************************************************************************************************/
#endif
