#ifndef _TOOLS_CLZ_H_
#define _TOOLS_CLZ_H_

/****************************************************************************************************************
 *
 * gcc can optimize this away when called with a constant
 *
 */
static inline unsigned int __constant_clz(unsigned int bits)  __attribute__((always_inline));

static inline unsigned int __constant_clz(unsigned int bits) {
  int result = 0;

  if (!bits) return 32;

  if (!(bits & 0xFFFF0000)) {
    bits <<= 16;
    result += 16;
  }

  if (!(bits & 0xFF000000)) {
    bits <<= 8;
    result += 8;
  }
	
  if (!(bits & 0xF0000000)) {
    bits <<= 4;
    result += 4;
  }
	
  if (!(bits & 0xC0000000)) {
    bits <<= 2;
    result += 2;
  }
	
  if (!(bits & 0x80000000)) {
    bits <<= 1;
    result += 1;
  }

  return result;
}

/****************************************************************************************************************/

__attribute__((__always_inline__)) static inline unsigned int __clz(unsigned int bits) {
  unsigned int result;

  asm("clz\t%0, %1" : "=r"(result) : "r"(bits));

  return result;
}

/****************************************************************************************************************/

#define clz(x) (__builtin_constant_p(x) ? __constant_clz(x) : __clz(x))

/****************************************************************************************************************/
#endif
