#ifndef PARSE_PARSER_H /***************************************************************************** -*- C -*- */
#define PARSE_PARSER_H

#include <sys/types.h>
#include <netinet/in.h>

/****************************************************************************************************************/

struct parser;

typedef void parser_command_t(struct parser *prs, void *data);

struct parser_command {
  const char *pc_cmd;
  parser_command_t *pc_func;
};

/****************************************************************************************************************/

// Initialize a parser with passed command table
struct parser *parse_init(const struct parser_command *command_table);
void parse_free(struct parser *prs);

// Run passed text through the parser
int parse_command(struct parser *prs, void *data, const char *cmdline);

/****************************************************************************************************************/

// While within a command callback, this returns the currently parsed input.
const char *parse_get_current_line(struct parser *prs);

// While within a command callback, this returns the currently parsed input,
// starting at the first char not yet processed.
const char *parse_get_current_pos(struct parser *prs);

/****************************************************************************************************************/

// Skips whitespace
void parse_skipspc(struct parser *prs);

// Returns true if next character is the expected character and skips it.
int parse_comma(struct parser *prs);

// Returns next char in stream
int parse_char(struct parser *prs);

// Returns true if at end of input.
int parse_end(struct parser *prs);

// Parses a signed integer, sets ok to true on success
int parse_int(struct parser *prs, int base, int *ok);

// Parses an unsigned integer, sets ok to true on success
unsigned int parse_uint(struct parser *prs, int base, int *ok);

// Parses for an 8-bit unsigned integer. Returns -1 on error.
int parse_byte(struct parser *prs);

// Parses for an 16-bit unsigned integer. Returns -1 on error.
int parse_word(struct parser *prs);

// Parses a quoted string
const char *parse_string(struct parser *prs, unsigned int *len_p);

// Expects a dotted quad NNN.NNN.NNN.NNN, returns true on success.
int parse_ip4(struct parser *prs, in_addr_t *ia);

// Expects a dotted quad and port number: NNN.NNN.NNN.NNN:PPPPP, returns true on success.
int parse_inet(struct parser *prs, struct sockaddr_in *sa);

/****************************************************************************************************************/
#endif
