#ifndef _LIBINSTALL_MTD_H_
#define _LIBINSTALL_MTD_H_

/*****************************************************************************************************************/

struct mtd {
  int fd;
  uint32 *bad_block_map;
  struct blk_geometry geo;
};

void install_mtd_init(struct mtd *mtd);

int install_mtd_open(struct mtd *mtd, const char *path);
void install_mtd_close(struct mtd *mtd);

int install_mtd_erase_sectors(struct mtd *mtd, size_t sector, size_t count);

int install_mtd_read_sector(struct mtd *mtd, void *data, void *oob, size_t sector);
int install_mtd_read_sectors_noecc(struct mtd *mtd, void *data, void *oob, size_t sector, size_t count);
int install_mtd_write_sector(struct mtd *mtd, const void *data, const void *oob, size_t sector);
int install_mtd_verify_sector(struct mtd *mtd, const void *data, const void *oob, size_t sector);

int install_mtd_write_flat_sectors(struct mtd *mtd, const void *data, size_t sector, size_t count);
int install_mtd_verify_flat_sectors(struct mtd *mtd, const void *data, size_t sector, size_t count);

int install_mtd_is_bad_sector(struct mtd *mtd, size_t sector);

void mtd_verify_error(const char *tag, uint sector, const void *want, const void *have, size_t size);

/*****************************************************************************************************************/
#endif
