#ifndef TIMER_H /********************************************************************************* -*- c++ -*- **/
#define TIMER_H

/****************************************************************************************************************/

#include <sys/time.h>
#include "object.h"

/****************************************************************************************************************/

class Timer : public Object {
public:
  Timer(Object *par = 0, const char *n = 0);
  Timer(int ms, bool single_shot = true, Object *par = 0, const char *n = 0);
  ~Timer();

public:

  void start(int ms, bool single_shot = true);
  void changeInterval(int ms);
  void stop(void);

  int timeout(void) const;
  int remaining(const struct timeval &tv) const;
  const struct timeval &expires(void) const { return m_expires;		     }
  bool isActive(void) const		    { return timerisset(&m_expires); }

public:
  bool checkpoint(const struct timeval &tv);

public:
  bool operator >  (const Timer &b) const;
  bool operator >= (const Timer &b) const;
  bool operator <  (const Timer &b) const;
  bool operator <= (const Timer &b) const;
  bool operator == (const Timer &b) const;
  bool operator != (const Timer &b) const;

protected:
  virtual void expired(void);

private:
  void start(int ms, bool single_shot, const struct timeval *ref);

public:
  virtual void dump(unsigned int spaces = 0);

private:
  friend class TimerQueue;
  struct timeval m_expires;
  int m_ms;
  Timer *m_next_timer;
  Timer *m_prev_timer;
};

/****************************************************************************************************************/

#endif
