#ifndef TEXTFILE_H /****************************************************************************** -*- c++ -*- **/
#define TEXTFILE_H

/****************************************************************************************************************/

#include "errtxt.h"

#include <stdio.h>

class TextFile : public ErrTxt {
public:
  TextFile(unsigned int maxsize = 131072, unsigned int maxlines = 1000);
  ~TextFile();

  void clear(void);

public:
  bool load(const char *filename);
  bool load(FILE *file);

  bool save(const char *filename);
  bool save(FILE *file);

  const char *line(unsigned int n) const;
  unsigned int lines(void) const { return m_lines; }

  bool insertLine(unsigned int n);
  void removeLine(unsigned int n);
  bool setLine(unsigned int n, const char *txt); // Returns true if text has changed

public:
  void setModified(bool m = true) { m_modified = m;    }
  bool modified(void) const       { return m_modified; }

public:
  void dump(void) const;

private:
  bool doSave(const char *filename);
  bool doSave(FILE *file);
  bool doSetLine(unsigned int n, const char *txt);

private:
  unsigned int m_maxlines;
  unsigned int m_maxsize;

   unsigned int m_lines;
  unsigned int m_size;

  char **m_text;

  bool m_modified;
};

/****************************************************************************************************************/

#endif
