#ifndef LIBEMB_SERIALPORT_H /********************************************************************* -*- c++ -*- **/
#define LIBEMB_SERIALPORT_H

/****************************************************************************************************************/

#include "descriptor.h"
#include <termios.h>

/****************************************************************************************************************/

class SerialPort : public Descriptor {
public:
  SerialPort(Object *par = 0, const char *n = 0);
  virtual ~SerialPort();

public:
  bool open(const char *tty, int speed = -1, int cflag = -1);
  virtual void close(void); // REIMP

public:
  bool setSpeed(int speed);
  bool setCFlag(int cflag);
  bool configureTiming(unsigned int vmin_bytes, unsigned int vtime_ms);

public:
  virtual bool drain(void); // REIMP
  virtual bool flush(void); // REIMP

public:
  static int getConfiguredSpeed(const char *device);
  int getConfiguredSpeed(void) const;

public:
  bool changeModemStatus(int on, int off);
  int modemStatus(void);

  bool setDTR(bool on);
  bool setCTS(bool on);

  bool getDTR(void);
  bool getDSR(void);
  bool getCTS(void);
  bool getRTS(void);
  bool getRI(void);
  bool getDCD(void);

private:
  struct termios m_oldtio;
};

/****************************************************************************************************************/

#endif
