#ifndef DESCRIPTOR_H /**************************************************************************** -*- c++ -*- **/
#define DESCRIPTOR_H

/****************************************************************************************************************/

#include "object.h"
#include "errtxt.h"

#include <sys/types.h>
#include <sys/uio.h>

class Descriptor : public Object, public ErrTxt {

public: // Construction
  Descriptor(Object *par = 0, const char *n = 0);

  // Destructor does not close automagically
  virtual ~Descriptor();

public: // File handle association
  virtual void setFd(int f);
  int fd(void) const { return m_fd; }
  virtual void close(void);

public: // Read/write signal activation
  void enableRead(bool en = true);
  void enableWrite(bool en = true);

  void disableRead(void)  { enableRead(false);  }
  void disableWrite(void) { enableWrite(false); }

  bool readEnabled(void) const;
  bool writeEnabled(void) const;

public: // Reading writing
  ssize_t write(const void *ptr, size_t len);
  ssize_t read(void *ptr, size_t bufsize);
  
  void writestr(const char *txt, ssize_t len = -1);
  void fmtstr(const char *fmt, ...);

  ssize_t readv(const struct iovec *vector, size_t count);
  ssize_t writev(const struct iovec *vector, size_t count);

  ssize_t safeWrite(const void *ptr, size_t count);
  ssize_t safeRead(void *ptr, size_t count);

public:
  // Wait until all buffered data has been sent.
  // Default implementation does nothing.
  virtual bool drain(void);

  // Discard any data in receive buffer.
  // Default implementation does nothing.
  virtual bool flush(void);

public: // Callback
  virtual void readyRead(void);
  virtual void readyWrite(void);

private:
  int m_fd;
};

/****************************************************************************************************************/

#endif
