#ifndef _CORE_USB_H_
#define _CORE_USB_H_

/****************************************************************************************************************/

#include <core/types.h>
#include <core/usbbits.h>

/****************************************************************************************************************
 *
 * Device identification
 *
 */
#define USB_NAME_MAX	128

struct usb_info {
  uint16 vid;
  uint16 pid;
  uint32 locid;
  char vendor[USB_NAME_MAX];
  char product[USB_NAME_MAX];
  char serial[USB_NAME_MAX];
};

/****************************************************************************************************************
 *
 * Configuration of HID Device Port driver
 *
 * When reading the config from the device:
 *  Before calling, set reportlen to the size of the buffer provided after the structure.
 *  On return, reportlen will be changed to the actual structure size.
 *
 */
struct usb_hid_config {
  uint8 version;	// Version of this structure (Must be 1)
  uint8 subclass;	// Value for bInterfaceSubClass of interface descriptor
  uint8 protocol;	// Value for bInterfaceProtocol of interface descriptor
  uint8 pad1;		// Unused, must be zero

  uint8 insize;		// Packet size of IN endpoint (1..64)
  uint8 outsize;	// Packet size of IN endpoint (0 to disable, 1..64)
  uint8 interval;	// Desired host polling frequency in ms (1..N, see USB specs)
  uint8 pad2;		// Unused, must be zero

  uint32 flags;		// Control behaviour of driver

  uint16 reportlen;	// Size of the following HID config descriptor
  uint8 report[0];	// Report descriptor follows
};

/****************************************************************************************************************/
#endif
