#ifndef LIBTTN_TTNCONFIG_H
#define LIBTTN_TTNCONFIG_H
/****************************************************************************************************************/
//
// Maximum size of one data packet's info contents
// For ethernet bridging, this must be 1514.
//
#define TTN_CONFIG_MAX_PAYLOAD_SIZE    1514

//
// Number of retransmits if there is a timeout
//
#define TTN_CONFIG_RETRANSMIT_TRIES      3

//
// Number of tries if the receiving station cannot accept a packet
// (by having RTR=0 or by sending NAK)
//
#define TTN_CONFIG_NAK_TRIES             10

//
// Number of entries in the switch MAC cache (MAC <-> TID)
//
#define TTN_CONFIG_MAC_CACHE_COUNT       64

//
// Interval between probing for new devices
//
#define TTN_CONFIG_PROBE_INTERVAL      5000

//
// Number of probing tries during enumeration phase
//
#define TTN_CONFIG_ENUM_TRIES             5

//
// Max time to wait for a response
//
#define TTN_CONFIG_RESPONSE_TIMEOUT     100

//
// When there are missing entries in the peer properties list,
// send a query every that many token rounds.
// Peer list is for diagnostics, take it easy.
//
#define TTN_CONFIG_QUERY_INTERVAL        10

/****************************************************************************************************************/
#endif
