#ifndef _CORE_TIME_H_ /******************************************************************************************/
#define _CORE_TIME_H_

#include <core/types.h>

/****************************************************************************************************************/

#define CLOCK_REALTIME		0
#define CLOCK_MONOTONIC		1

/****************************************************************************************************************/

struct timespec {
  time_t	tv_sec;
  long		tv_nsec;
};

/****************************************************************************************************************/

struct timeval {
  time_t	tv_sec;
  suseconds_t	tv_usec;
};

/****************************************************************************************************************/

struct _clk_adjtime {
  int32_t req;
  int32_t delta;
};

/****************************************************************************************************************/

#define	TIMEVAL_TO_TIMESPEC(tv, ts) {					\
	(ts)->tv_sec = (tv)->tv_sec;					\
	(ts)->tv_nsec = (tv)->tv_usec * 1000;				\
}

#define	TIMESPEC_TO_TIMEVAL(tv, ts) {					\
	(tv)->tv_sec = (ts)->tv_sec;					\
	(tv)->tv_usec = (ts)->tv_nsec / 1000;				\
}

/****************************************************************************************************************/
#endif
